/*
 * Decompiled with CFR 0.152.
 */
package fr.free.kueny.patrice.pilot;

import fr.free.kueny.patrice.pilot.Cockpit;
import fr.free.kueny.patrice.pilot.Pilot;
import fr.free.kueny.patrice.pilot.PlaneConfig;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;

public class Plane
extends JPanel {
    public static final int base = 10;
    public final Pilot pilot;
    public final PlaneConfig config;
    public final Cockpit cockpit;
    public double y;
    public double yDelta;
    public double x;
    public double xDelta;
    public double power;
    public double wing;
    public double moveAngle;
    public double speed;
    public int state;
    public static final int GROUND = 0;
    public static final int AIR = 1;
    public static final int CRASH = 2;
    public static final int BURNING = 3;
    public final Copy copy;

    public Plane(Pilot pilot, PlaneConfig config, Cockpit cockpit, String location) {
        this.pilot = pilot;
        this.config = config;
        this.cockpit = cockpit;
        this.x = 125.0;
        this.xDelta = 0.0;
        this.y = 0.0;
        this.yDelta = 0.0;
        this.state = 0;
        this.power = 0.0;
        this.speed = 0.0;
        this.moveAngle = 0.0;
        this.wing = 0.0;
        this.setOpaque(false);
        this.setBounds((int)this.x, (int)(390.0 - this.y - (double)(config.dim / 2 + 10)), config.dim, config.dim);
        this.copy = new Copy();
        this.setToolTipText(location);
    }

    public boolean doAction(int action) {
        switch (action) {
            case 0: {
                this.changeWings(-1);
                break;
            }
            case 1: {
                this.changeWings(1);
                break;
            }
            case 2: {
                if (this.xDelta == 0.0 && (this.state == 0 || this.state == 3)) {
                    return true;
                }
                this.changePower(-1);
                break;
            }
            case 3: {
                this.changePower(1);
            }
        }
        return false;
    }

    public void changePower(int delta) {
        if (this.state <= 1) {
            double minPower;
            this.power += (double)delta * this.config.maxPower * 0.1;
            double d = minPower = this.state == 0 && this.config.isPlane ? -this.config.maxPower : 0.0;
            if (this.power < minPower) {
                this.power = minPower;
            } else if (this.power > this.config.maxPower) {
                this.power = this.config.maxPower;
            }
        }
    }

    public void changeWings(int delta) {
        if (this.state <= 1) {
            this.wing += (double)delta * this.config.maxWing * 0.1;
            if (this.wing < -this.config.maxWing) {
                this.wing = -this.config.maxWing;
            } else if (this.wing > this.config.maxWing) {
                this.wing = this.config.maxWing;
            }
        }
    }

    private void computeMovement() {
        double sdx = 0.0;
        double sdy = 0.0;
        double g = 0.2 * this.config.mass;
        double dx = 0.0;
        double dy = -g;
        sdx += dx;
        sdy += dy;
        double i = this.speed * (1.0 - 0.05 * this.speed / this.config.maxSpeed);
        dx = Math.cos(this.moveAngle) * i;
        dy = Math.sin(this.moveAngle) * i;
        sdx += dx;
        sdy += dy;
        if (this.state <= 1 && this.config.isPlane) {
            double t = 0.2 * (this.speed / this.config.maxSpeed) * (this.speed / this.config.maxSpeed) * (1.0 - this.y / 360.0);
            dx = Math.cos(this.moveAngle + 1.5707963267948966) * t;
            dy = Math.sin(this.moveAngle + 1.5707963267948966) * t;
            sdx += dx;
            sdy += dy;
        }
        double p = 0.1 * this.power * this.config.mass * (1.0 - 0.5 * this.speed / this.config.maxSpeed) * (1.0 - 0.5 * this.y / 360.0);
        if (this.config.isPlane) {
            if (p >= 0.0) {
                dx = Math.cos(this.moveAngle) * p;
                dy = Math.sin(this.moveAngle) * p;
            } else {
                dx = 0.1 * this.power / this.config.maxPower * sdx;
                dy = 0.0;
            }
        } else {
            dx = Math.cos(1.5707963267948966 - this.wing) * p;
            dy = Math.sin(1.5707963267948966 - this.wing) * p;
        }
        sdx += dx;
        sdy += dy;
        if (this.state <= 1 && this.config.isPlane) {
            double w = 0.02 * this.wing * (this.speed / this.config.maxSpeed);
            dx = Math.cos(this.moveAngle + 1.5707963267948966) * w;
            dy = Math.sin(this.moveAngle + 1.5707963267948966) * w;
            sdx += dx;
            sdy += dy;
        }
        if (this.y == 0.0) {
            if (sdy < 0.0) {
                sdy = 0.0;
            }
            if (this.config.isPlane) {
                if (this.state >= 2) {
                    sdx *= 0.8;
                }
            } else {
                sdx *= 0.8;
            }
        }
        this.speed = Math.sqrt(sdx * sdx + sdy * sdy);
        if (this.speed < 0.01) {
            sdy = 0.0;
            sdx = 0.0;
            this.speed = 0.0;
        } else {
            this.moveAngle = Math.acos(sdx / this.speed);
            if (sdy < 0.0) {
                this.moveAngle = -this.moveAngle;
            }
        }
        this.xDelta = sdx;
        this.yDelta = sdy;
    }

    public void animate() {
        this.computeMovement();
        this.x = (this.x + this.xDelta + 780.0) % 780.0;
        this.y += this.yDelta;
        switch (this.state) {
            case 0: {
                if (!(this.y > 0.0)) break;
                this.state = 1;
                break;
            }
            case 1: {
                if (this.y <= 0.0) {
                    this.y = 0.0;
                    if (this.config.isPlane) {
                        this.state = this.speed < 5.0 && Math.abs(this.moveAngle) < 0.3141592653589793 ? 0 : 2;
                        break;
                    }
                    this.state = this.speed < 5.0 && Math.abs(this.wing) <= 0.3141592653589793 ? 0 : 2;
                    break;
                }
                if (!(this.y > 360.0)) break;
                this.y = 360.0;
                this.state = 2;
                break;
            }
            case 2: {
                if (this.y <= 0.0) {
                    this.y = 0.0;
                    this.moveAngle = 0.0;
                    if (this.speed < 10.0) {
                        this.state = 3;
                    }
                }
                this.power = 0.0;
                break;
            }
            case 3: {
                this.y = 0.0;
                this.power = 0.0;
                this.speed = 0.0;
            }
        }
        if (!(this.state > 1 || !(this.y < 20.0) || this.x >= 125.0 && this.x + (double)this.config.dim <= 480.0)) {
            this.state = 2;
        }
        this.setLocation((int)this.x, (int)(390.0 - this.y - (double)(this.config.dim / 2 + 10)));
        this.copy.animate();
    }

    public Image computeImage(Graphics2D g2) {
        Image image = null;
        switch (this.state) {
            case 0: 
            case 1: {
                Image image2 = image = this.y > 20.0 ? this.config.image_flying : this.config.image_landing;
                double angle = this.config.isPlane ? (this.y > 20.0 ? -this.moveAngle : -this.moveAngle - this.config.groundAngle * (1.0 - this.speed / this.config.maxSpeed)) : this.wing;
                g2.transform(AffineTransform.getRotateInstance(angle, this.config.dim / 2, this.config.dim / 2));
                break;
            }
            case 2: {
                image = this.config.image_crashed;
                break;
            }
            case 3: {
                image = this.config.image_burning;
            }
        }
        return image;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Image image = this.computeImage(g2);
        g2.drawImage(image, 0, 0, this);
    }

    public class Copy
    extends JPanel {
        public Copy() {
            this.setOpaque(false);
            this.setBounds((int)(Plane.this.x - 780.0), (int)(390.0 - Plane.this.y - (double)(Plane.this.config.dim / 2 + 10)), Plane.this.config.dim, Plane.this.config.dim);
        }

        public void animate() {
            this.setLocation((int)(Plane.this.x - 780.0), (int)(390.0 - Plane.this.y - (double)(Plane.this.config.dim / 2 + 10)));
        }

        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Image image = Plane.this.computeImage(g2);
            g2.drawImage(image, 0, 0, this);
        }
    }
}

