/*
 * Decompiled with CFR 0.152.
 */
package fr.free.kueny.patrice.pilot;

import fr.free.kueny.patrice.pilot.Cloud;
import fr.free.kueny.patrice.pilot.Cockpit;
import fr.free.kueny.patrice.pilot.CockpitConfig;
import fr.free.kueny.patrice.pilot.Environment;
import fr.free.kueny.patrice.pilot.ImagePanel;
import fr.free.kueny.patrice.pilot.Plane;
import fr.free.kueny.patrice.pilot.PlaneConfig;
import fr.free.kueny.patrice.pilot.Star;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.Timer;

public class Pilot
extends JApplet
implements ActionListener,
KeyListener {
    private static final PlaneConfig airbusConfig = new PlaneConfig("airbus", 80, 1.0, 10.0, 5.0, 4.0, 0.0, true);
    private static final PlaneConfig biplanConfig = new PlaneConfig("biplan", 40, 0.5, 5.0, 3.0, 5.0, 0.2617993877991494, true);
    private static final PlaneConfig helicoConfig = new PlaneConfig("helico", 60, 0.5, 7.0, 1.5, 0.7853981633974483, 0.0, false);
    public static final PlaneConfig[] planeConfigs = new PlaneConfig[]{airbusConfig, biplanConfig, helicoConfig};
    public static final Font indicatorFont = new Font("dialog", 1, 9);
    public static final Font titleFont = new Font("sans-serif", 1, 13);
    public static final int SYSTEM_TIMER_MS = 100;
    private final Timer timer;
    public static final int bgWidth = 780;
    public static final int bgStartPlace = 125;
    public static final int bgEndPlace = 480;
    public static final int bgHeight = 400;
    public static final int bgTrees = 320;
    public static final int bgGround = 390;
    public static final int bgAltMax = 360;
    public Cockpit cockpit1;
    public Cockpit cockpit2;
    public Cloud[] clouds = new Cloud[8];
    public Star star;
    public static final Integer bgLevel = new Integer(10);
    public static final Integer starLevel = new Integer(11);
    public static final Integer plane1Level = new Integer(15);
    public static final Integer plane2Level = new Integer(16);
    public static final Integer cloudsLevel = new Integer(19);

    public void actionPerformed(ActionEvent evt) {
        if (!this.hasFocus()) {
            this.requestFocus();
        }
        this.star.animate();
        int i = this.clouds.length - 1;
        while (i >= 0) {
            this.clouds[i].animate();
            --i;
        }
        this.cockpit1.animate();
        this.cockpit2.animate();
        if (this.cockpit1.plane != null && this.checkCollision(this.cockpit1.plane.x, this.cockpit1.plane.y, this.cockpit1.plane.config, this.cockpit2.plane)) {
            if (this.cockpit1.plane.state < 2) {
                this.cockpit1.plane.state = 2;
            }
            if (this.cockpit2.plane.state < 2) {
                this.cockpit2.plane.state = 2;
            }
        }
    }

    public boolean checkCollision(double x, double y, PlaneConfig config, Plane plane2) {
        if (plane2 != null) {
            double xDist = Math.abs(x + (double)(config.dim / 2) - (plane2.x + (double)(plane2.config.dim / 2)));
            xDist = Math.min(xDist, 780.0 - xDist);
            double yDist = Math.abs(y + 10.0 - (plane2.y + 10.0));
            return xDist < (double)((config.dim + plane2.config.dim) / 3) && yDist < (double)((config.dim + plane2.config.dim) / 3);
        }
        return false;
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        this.cockpit1.keyPressed(e);
        this.cockpit2.keyPressed(e);
    }

    public Pilot() {
        this.timer = new Timer(100, this);
        this.timer.setCoalesce(true);
    }

    private Container makeContentPane() {
        int i = 0;
        while (i < planeConfigs.length) {
            planeConfigs[i].init(this);
            ++i;
        }
        Container contentPanel = this.getContentPane();
        JLayeredPane layeredPane = new JLayeredPane();
        ImagePanel bg = new ImagePanel(true);
        bg.init(Environment.singleton().getImage("bg.gif"), 780, 400);
        layeredPane.add((Component)bg, bgLevel);
        layeredPane.setPreferredSize(new Dimension(780, 400));
        this.star = new Star(layeredPane, starLevel);
        int i2 = this.clouds.length - 1;
        while (i2 >= 0) {
            this.clouds[i2] = new Cloud(layeredPane, cloudsLevel, i2);
            --i2;
        }
        JPanel topPanel = new JPanel();
        topPanel.setBackground(Color.black);
        topPanel.add(layeredPane);
        contentPanel.add((Component)topPanel, "Center");
        this.cockpit1 = new Cockpit(this, layeredPane, CockpitConfig.config1, 0);
        this.cockpit2 = new Cockpit(this, layeredPane, CockpitConfig.config2, 1);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.add((Component)this.cockpit1, "West");
        JPanel titlePanel = new JPanel();
        titlePanel.setBackground(Color.black);
        titlePanel.setLayout(new BoxLayout(titlePanel, 1));
        JLabel title1label = new JLabel("Pilote d'avion v1.1");
        title1label.setForeground(Color.white);
        title1label.setAlignmentX(0.5f);
        title1label.setFont(titleFont);
        titlePanel.add(title1label);
        JLabel title2label = new JLabel("\u00a92005 Patrice KUENY");
        title2label.setForeground(Color.white);
        title2label.setAlignmentX(0.5f);
        title2label.setFont(titleFont);
        titlePanel.add(title2label);
        JLabel title3label = new JLabel("http://patrice.kueny.free.fr");
        title3label.setForeground(Color.white);
        title3label.setAlignmentX(0.5f);
        title3label.setFont(titleFont);
        titlePanel.add(title3label);
        bottomPanel.add((Component)titlePanel, "Center");
        bottomPanel.add((Component)this.cockpit2, "East");
        contentPanel.add((Component)bottomPanel, "South");
        return contentPanel;
    }

    public void init() {
        this.setContentPane(this.makeContentPane());
        this.addKeyListener(this);
    }

    public void start() {
        this.timer.start();
    }

    public void stop() {
        this.timer.stop();
    }

    public void destroy() {
        this.timer.stop();
        this.getContentPane().removeAll();
        this.removeKeyListener(this);
    }

    public static void main(String[] args) {
        Pilot pilot = new Pilot();
        JFrame frame = new JFrame("Pilote d'avion");
        frame.setIconImage(Environment.singleton().getImage("pilot.gif"));
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(pilot.makeContentPane());
        frame.addKeyListener(pilot);
        frame.pack();
        Rectangle screenBounds = frame.getGraphicsConfiguration().getBounds();
        frame.setLocation(screenBounds.x + (screenBounds.width - frame.getWidth()) / 2, screenBounds.y + (screenBounds.height - frame.getHeight()) / 2);
        frame.setVisible(true);
        pilot.start();
    }
}

